//>>>>>>>>>>>>>>>>>>>>>>>>
//cgi-thermocouple.c
//>>>>>>>>>>
//This file contains the CGI responder function for the Thermocouple Reader configuration page.
//



#include <mqx.h>
#include <httpd.h>
#include <main.h>
#include <cgi.h>
#include <string.h>

#include <ltctwrutils.h>
#include <ltctwrboard.h>

extern HTTPSRV_CGI_RES_STRUCT response;
extern char     buffer[100];
extern uint_32  ptr;

//CGI Function to read from the thermocouple

_mqx_int cgi_thermocouple_data(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32 value1, value2,len;
        char buff[20];
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
        HTTPSRV_CGI_RES_STRUCT response;        
        response.ses_handle = param->ses_handle;
        response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
        response.status_code = 200;

	//Get pointer
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();	
	value1 = (LTCTWR_Params_Ptr->result);  //For uint_32	
	value2 = (LTCTWR_Params_Ptr->temperature);  //For uint_32        
	len = snprintf(buff, 20, "%d\n%d\n", value1, value2);      
        response.data = buff;
        response.data_length = len;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);    

	return response.content_length;
}


_mqx_int cgi_thermocouple_set(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32  len = 0;
	char     channel[10], setting[10];
	boolean  bParams = FALSE; 
	char buffer[100];
        HTTPSRV_CGI_RES_STRUCT response;
	
	
	
	uint_8 chanindex, setindex;
	uint_8 mask = 0x41;
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;

	//Get pointer and configure as the 2498
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
        LTCTWR_Params_Ptr->chip = LTCTWR_2498;
	LTCTWR_Params_Ptr->mode = READ;

	

	//If we got a response of non-zero length
	
	if (param->content_length) {
    	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, (len > sizeof(buffer)) ? sizeof(buffer) : len);
    	buffer[len] = 0;
    	param->content_length -= len;
        len = 0;
    	
    	//Check if all contents are present
		if (cgi_get_varval(buffer, "channel", channel, sizeof(channel)) &&
			cgi_get_varval(buffer, "setting", setting, sizeof(setting))) {
			
			bParams =  TRUE;
         
            chanindex = (*(char*)channel) - mask; //Figure out the Channel
            printf("Channel Index: %d\n", chanindex);
            setindex = (*(char*)setting) - mask;//Figure out the Span
            printf("Setting Index: %d\n", setindex);
            
            set_decoder_channel(LTC2498_channel, LTCTWR_Params_Ptr);
            
            lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
		    LTCTWR_Params_Ptr->temperature = send_receive_LTC2498 (LTC2498ChannelSelect[chanindex], LTC2498_TEMP_REJECT_50_60_X1, LTCTWR_Params_Ptr->spifd);
		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
		    _time_delay(150);
		    //For flushing
		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
		    LTCTWR_Params_Ptr->temperature = send_receive_LTC2498 (LTC2498ChannelSelect[chanindex], LTC2498SettingSelect[setindex], LTCTWR_Params_Ptr->spifd);
		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
                    printf("Read 2498 Temperature -- Value: 0x%08x or %d \n\n", LTCTWR_Params_Ptr->temperature, LTCTWR_Params_Ptr->temperature);
						
		    _time_delay(150);
		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
   		    LTCTWR_Params_Ptr->result = send_receive_LTC2498 (LTC2498ChannelSelect[chanindex], LTC2498SettingSelect[setindex], LTCTWR_Params_Ptr->spifd);
   		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
                     printf("Read 2498 Result -- Value: 0x%08x or %d \n\n", LTCTWR_Params_Ptr->result, LTCTWR_Params_Ptr->result);
   		    fflush (LTCTWR_Params_Ptr->spifd);

            
                
			
////////////////SPECIAL REV D EDIT ////////////////////////////////
#if defined BSP_TWR_K60D100M
#if defined K60N512_REV_D
            set_decoder_channel(0x01, LTCTWR_Params_Ptr); // bring GPIO7 high to bring Ethernet transceiver out of reset
	    _time_delay(3500);			          // allow time for Ethernet transceiver to come out of reset
#endif            
#endif
////////////////END SPECIAL REV D EDIT ////////////////////////////////         
    		 response.ses_handle = param->ses_handle;
                 response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
                 response.status_code = 200;	
    		 response.data = 
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=thermocouple.html\"></HEAD>"
			"<BODY></BODY></HTML>";   		
   		 response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
   		}
   	}
  
   
	if (!bParams) {
		response.data =  "No parameters received.<br>\n";
                response.data_length = strlen(response.data);
        HTTPSRV_cgi_write(&response);
	}
	
	
	response.data = "<br><br>\n</body></html>";
    response.data_length = strlen(response.data);
    HTTPSRV_cgi_write(&response);    
    return (response.content_length);
	
}
